---------------- triggers para auditoria de alterao do status de credito do conveniado ----------------------------
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CLI_CRED_RC_CLI_ALT_STS_CRED]'))

/****** Object:  Trigger [TRG_RC_CLI_CRED_RC_CLI_ALT_STS_CRED]    Script Date: 29/05/2015 09:40:35 ******/
DROP TRIGGER [dbo].[TRG_RC_CLI_CRED_RC_CLI_ALT_STS_CRED]
GO

/****** Object:  Trigger [dbo].[TRG_RC_CLI_CRED_RC_CLI_ALT_STS_CRED]    Script Date: 29/05/2015 09:40:35 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE TRIGGER [dbo].[TRG_RC_CLI_CRED_RC_CLI_ALT_STS_CRED] ON [dbo].[RC_CLI_CREDIARIO] AFTER  UPDATE
AS

BEGIN TRY
	IF UPDATE(STS_CRED) 
		BEGIN
			INSERT INTO RC_CLI_CRED_RC_CLI_AUDITORIA (CD_EMP,CD_CLI,CD_USU_ALT,STS_CRED,DT_ALT) 
			SELECT       
				A.CD_EMP,
				A.CD_CLI,
				ISNULL(A.CD_USU_ALT,C.CD_USU_ALT) AS CD_USU_ALT,
				A.STS_CRED,
				GETDATE() AS DT_ALT
			FROM       
			INSERTED A INNER JOIN RC_CLI C ON
			A.CD_EMP=C.CD_EMP AND
			A.CD_CLI=C.CD_CLI 
		END

END TRY
BEGIN CATCH
	ROLLBACK TRAN
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH


GO




